#pragma once
#include "EditListCtrl.h"
#include "SkinProgress.h"
#include "ProfileDll.h"
#include "ServiceDlg.h"

/////////////////////////////////////////////////////////////////////////////
// CConfigPHBDlg dialog
/////////////////////////////////////////////////////////////////////////////
#define kIndexCol			0
#define kNameCol			1
#define kNumberCol			2
#define kCharSetCol			3
/////////////////////////////////////////////////////////////////////////////
// CServiceSMSDlg dialog
/////////////////////////////////////////////////////////////////////////////
class CServicePHBDlg : public CServiceDlg
{
	DECLARE_DYNAMIC(CServicePHBDlg)
private:
	virtual int		GetIconId()		{ return IDI_ICON_PHB; };
public:
	enum { IDD = IDD_DLGSVC_PHB_MAIN };
	CServicePHBDlg(CService* iSvcSMS) : CServiceDlg(CServicePHBDlg::IDD, theApp.m_hInstance, iSvcSMS){};
	virtual ~CServicePHBDlg() {};	
protected:
	virtual void DoDataExchange(CDataExchange* pDX)	{ CDialog::DoDataExchange(pDX); };
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL	OnInitDialog()	{ CDialog::OnInitDialog(); return TRUE; };
	virtual char*	GetName()		{ return "PhoneBook";};
	virtual void	UpdateDisplay()	{};
	virtual BOOL	Apply()			{ return TRUE; };
};
/////////////////////////////////////////////////////////////////////////////
class CServicePHBDlgStorage : public CServiceDlg
{
	DECLARE_DYNAMIC(CServicePHBDlgStorage)
private:
	CString			mStorage;
	char*			mFullNameP;
public:
	enum { IDD = IDD_DLGSVC_PHB_STORAGE };
	CServicePHBDlgStorage(CService* iSvcPHB, CString iStorage);
	virtual ~CServicePHBDlgStorage() {delete[] mFullNameP;};
protected:
	virtual void	DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL	OnInitDialog();
	virtual char*	GetName();
	virtual void	UpdateDisplay();
	virtual BOOL	Apply();
	CEdit			mEditTotal, mEditUsed;
	CEditListCtrl	mListPHB;	
	CButton			mButtonAdd, mButtonRemove, mButtonRemoveAll, mButtonPopulate, mCheckWP;
	CStatic			mStaticPHB;
	afx_msg void	OnBnClickedButtonAdd();
	afx_msg void	OnNMDblclkListPhb(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void	OnBnClickedButtonRemove();
	afx_msg void	OnBnClickedButtonRemoveAll();
	afx_msg void	OnBnClickedButtonPopulate();
	afx_msg void	OnBnClickedCheckWp();
	virtual void	UpdateUI();
private:
	int PrvGetListCtrlItem(int iIndexValue);
};
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////